import { View, Text } from "react-native";
import React from "react";
import styles from "./RatingStyles";
import { dummyData } from "./data/dummyData"; // TODO: will be replaced with real data then (delete it's folder)
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";
import Porgressbar from "../../../Porgressbar/Porgressbar";
import CustomRating from "../../../../../screens/Utilities/CustomRating/CustomRating";
import useLangTranslation from "../../../../../hooks/useLangTranslation";

const Rating = () => {
    const { trans } = useLangTranslation();
    return (
        <View style={styles.container}>
            <View style={styles.headerContent}>
                <Text style={styles.ratingCount}>4.4</Text>
                <View>
                    <Text style={styles.averageText}>{trans("Average Rating")}</Text>
                    <View style={styles.ratingDec}>
                        <CustomRating rating={4} />
                        <Text style={styles.reviewsText}>
                            ({trans("reviewCount", {count: 12})})
                        </Text>
                    </View>
                </View>
            </View>
            <View style={styles.ratingVisualize}>
                {dummyData.map((d) => (
                    <View key={d.id} style={styles.bodyContent}>
                        <CustomRating rating={4} starSize={dpr(16)} />
                        <View style={styles.progress}>
                            <Porgressbar progress={d.values} />
                        </View>
                        <Text style={styles.percentage}>{d.values}%</Text>
                    </View>
                ))}
            </View>
        </View>
    );
};

export default Rating;
